 /*///////////////////////////////////////////////
          Given a matrix A [1..n][1..n],
         its inverse in matrix B[1..n][1..n]
 ///////////////////////////////////////////////*/

#include "ludcmp.c" 
#include "lubksb.c" 

void inv(A,n,B)
float **A,**B;
int n;
{
  int   i,j;
  float d,*v1,**C;
  int   *v;

  C=matrix(1,n,1,n);
  v=ivector(1,n);
  v1=vector(1,n);
  
  for(i=1;i<=n;i++)
      for(j=1;j<=n;j++) C[i][j]=A[i][j];
  ludcmp(C,n,v,&d);

  for(j=1;j<=n;j++){
      for(i=1;i<=n;i++) v1[i]=0.0;
      v1[j]=1.0;
      lubksb(C,n,v,v1);



      for(i=1;i<=n;i++) B[i][j]=v1[i];
      }

  free_ivector(v,1,n);
  free_vector(v1,1,n);
  free_matrix(C,1,n,1,n);

}/*///the end of inv.c//////*/ 
